
#ifndef BOOST_PP_IS_ITERATING

	#ifndef KETCHUP_ALT_MSG_MAP_INCLUDED
		#define KETCHUP_ALT_MSG_MAP_INCLUDED

		#include <boost/preprocessor/arithmetic/sub.hpp>
		#include <boost/preprocessor/cat.hpp>
		#include <boost/preprocessor/comparison/equal.hpp>
		#include <boost/preprocessor/facilities/identity.hpp>
		#include <boost/preprocessor/iteration/iterate.hpp>
		#include <boost/preprocessor/iteration/local.hpp>
		#include <boost/preprocessor/punctuation/comma_if.hpp>
		#include <boost/preprocessor/repetition/enum.hpp>
		#include <boost/preprocessor/repetition/enum_params.hpp>
		#include <boost/preprocessor/repetition/enum_params_with_a_default.hpp>
		#include <boost/preprocessor/repetition/repeat.hpp>
		#include <boost/preprocessor/stringize.hpp>

		#ifndef KETCHUP_LIMIT_ALT_MSG_MAP_SIZE
			#define KETCHUP_LIMIT_ALT_MSG_MAP_SIZE 30
		#endif
		
		// local macro
		#define KETCHUP_identity(z, n, data) data
		
		#define KETCHUP_alt_msg_map_statement(z, i, unused) \
		if (E##i::process(derived, hWnd, uMsg, wParam, lParam, lResult, dwMsgMapID, bHandled)) \
		{ \
			return true; \
		} \
		/**/

		// header
		BOOST_PP_IDENTITY(#pragma once)()
		BOOST_PP_IDENTITY(#include "../utility/na.hpp")()
		
		namespace ketchup
		{


// primary
template<
	DWORD msgMapID,
	BOOST_PP_ENUM_PARAMS_WITH_A_DEFAULT(KETCHUP_LIMIT_ALT_MSG_MAP_SIZE, class E, na)
>
struct alt_msg_map
{
	template< class Derived >
	static bool process(Derived& derived, HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam, LRESULT& lResult, DWORD dwMsgMapID, BOOL& bHandled)
	{
		if (dmMsgMapID != msgMapID) { return false; }
		
		#define BOOST_PP_LOCAL_MACRO(n) KETCHUP_alt_msg_map_statement(~, n, ~)
		#define BOOST_PP_LOCAL_LIMITS (0, KETCHUP_LIMIT_ALT_MSG_MAP_SIZE-1)
		#include BOOST_PP_LOCAL_ITERATE()
		#undef BOOST_PP_LOCAL_MACRO

		return false;
	}
};

// empty
template<
	DWORD msgMapID
>
struct alt_msg_map<
	DWORD msgMapID,
	BOOST_PP_ENUM(KETCHUP_LIMIT_ALT_MSG_MAP_SIZE, KETCHUP_identity, na)
>
{
	template< class Derived >
	static bool process(Derived&, HWND, UINT, WPARAM, LPARAM, LRESULT&, DWORD, BOOL&)
	{
		return false;
	}
};


		#define BOOST_PP_ITERATION_LIMITS(1, KETCHUP_LIMIT_ALT_MSG_MAP_SIZE-1)
		#define BOOST_PP_FILENAME_1 "alt_msg_map.hpp"
		#include BOOST_PP_ITERATE()

		// clean up
		
		} // namespace ketchup
		
		#undef KETCHUP_identity
		#undef KETCHUP_alt_msg_map_statement

	#endif // KETCHUP_ALT_MSG_MAP_INCLUDED

#else // BOOST_PP_IS_ITERATING

	#define n BOOST_PP_ITERATION()


template<
	DWORD msgMapID,
	BOOST_PP_ENUM_PARAMS(n, class E)
>
struct alt_msg_map<
	DWORD msgMapID,
	BOOST_PP_ENUM_PARAMS(n, class E) BOOST_PP_COMMA_IF(n)
	BOOST_PP_ENUM(BOOST_PP_SUB(KETCHUP_LIMIT_ALT_MSG_MAP_SIZE, n), KETCHUP_identity, na)
>
{
	template< class Derived >
	static bool process(Derived& derived, HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam, LRESULT& lResult, DWORD dwMsgMapID, BOOL& bHandled)
	{
		if (dmMsgMapID != msgMapID) { return false; }
		
		#define BOOST_PP_LOCAL_MACRO(n) KETCHUP_alt_msg_map_statement(~, n, ~)
		#define BOOST_PP_LOCAL_LIMITS (0, n-1)
		#include BOOST_PP_LOCAL_ITERATE()
		#undef BOOST_PP_LOCAL_MACRO

		return false;
	}
};


	#undef n

#endif // BOOST_PP_IS_ITERATING
